/* FILE: mscreen.h                              (D. Tottingham  03/23/91)

This is an include file of defines, data structure definitions and
external declarations that are common in the mscreen module.

*/

#ifndef _MSCREEN_
#define _MSCREEN_

/************************************************************************
                               INCLUDES

************************************************************************/
#include "mconst.h"
#include "mvideo.h"


/************************************************************************
                                DEFINES

************************************************************************/
#define MAX_MAGNIFICATION       3
#define MAX_BLOCK               16
#define MAX_DISPLAY             32
#define MAX_TEXTLINE            40

#define N_DISPLAYS              2

/* Display types */
#define LIST                    0
#define RANGE                   1

/* Display ids */
#define HOME                    0
#define BLOCK                   1

/* Screen ids */
#define SCREEN_0                0               /* text */
#define SCREEN_1                1               /* waveforms */
#define SCREEN_2                2               /* help */

/* Screen dimensions */
#define TOP_MARGIN              50
#define BOTTOM_MARGIN           9
#define LEFT_MARGIN             126
#define RIGHT_MARGIN            2
#define CHANNEL_HEIGHT          16
#define HORIZONTAL_PIXS         512
#define VERTICAL_PIXS           ((MAXI) - (TOP_MARGIN) - (BOTTOM_MARGIN))

/* Bar Constants */
#define BIG_RECT_I1             TOP_MARGIN
#define BIG_RECT_J1             3
#define BIG_RECT_I2             ((MAXI) - (BOTTOM_MARGIN) - 1)
#define BIG_RECT_J2             13
#define BIG_RECT_WDTH           ((BIG_RECT_I2) - (BIG_RECT_I1) - 2)
#define BIG_RECT_COLOR          YELLOW

#define SMALL_RECT_J1           ((BIG_RECT_J1) + 1)
#define SMALL_RECT_J2           ((BIG_RECT_J2) - 1)
#define SMALL_RECT_COLOR        WHITE

/* Colors */
#define BCKGND_COLOR            BLACK
#define HEADER_I                32
#define HEADER_COLORS           YELLOW, BCKGND_COLOR, BCKGND_COLOR
#define HELP_COLORS             YELLOW, BCKGND_COLOR, BCKGND_COLOR
#define PLOT_ON_COLOR           WHITE
#define PLOT_OFF_COLOR          BCKGND_COLOR
#define PLOTMOD_COLORS          WHITE, BCKGND_COLOR
#define TEXT_COLORS             YELLOW, BCKGND_COLOR, BCKGND_COLOR
#define TEXT_OFF_COLORS         BCKGND_COLOR, BCKGND_COLOR, BCKGND_COLOR
#define TRIGGER_ON_COLORS       LIGHT_RED, BCKGND_COLOR, BCKGND_COLOR
#define TRIGGER_OFF_COLORS      BCKGND_COLOR, BCKGND_COLOR, BCKGND_COLOR


/************************************************************************
                        STRUCTURE DEFINITIONS


************************************************************************/
typedef struct {
        unsigned int type;
        unsigned int n_channels;
        unsigned int orientation;
        int begin_channel;
        unsigned int channel_list[MAX_DISPLAY];
} S_DISPLAY;

typedef struct {
        float        srate;
        unsigned int decimation;
        int          magnification;
        double       left_time;
        double       right_time;
} S_HEADER;


/************************************************************************
                         EXTERNAL DECLARATIONS

These functions can be called from all modules that include this file.

************************************************************************/
PUBLIC FLAG s_add_channel (unsigned int);
PUBLIC void s_clear ();
PUBLIC void s_display_bar ();
PUBLIC void s_display_ids ();
PUBLIC void s_display_traces (int, int);
PUBLIC void s_display_triggers ();
PUBLIC void s_initialize ();
PUBLIC void s_initialize_screen ();
PUBLIC FLAG s_remove_channel (unsigned int);
PUBLIC void s_reset_screen ();
PUBLIC FLAG s_screen_on ();
PUBLIC void s_select_display (unsigned int);
PUBLIC void s_select_screen (unsigned int);
PUBLIC FLAG s_set_channelrange (int, unsigned int);
PUBLIC void s_view_help ();

#endif
